#ifndef __SPELLWRI__
#define __SPELLWRI__

#include "platform.h"

//#ifdef MACOS
#include <Files.h>
//#endif


#ifdef MACOS
//#include <Desk.h>
#define FioParam FSSpec
#endif

#ifdef _WINDOWS_
#include <windows.h>

#ifndef FioParam
#define FioParam char
#endif
#endif

#ifdef _MSDOS_
#ifndef FioParam
#define FioParam char
#endif
#endif


// Error Numbers
#define eNo_Err					(0)
#define eNo_Mem  				(-1)
#define eOpening_File  			(-2)
#define eNot_Dictionary  		(-3)
#define eUser_Dict_Corrupted  	(-4)
#define eNot_Done  				(-5)
#define eDone  					(-6)
#define eGeneral 				(-7)
#define eReading_File			(-8)
#define eWriting_File			(-9)
#define eUnusableDict			(-10)
#define eNotSpeller				(-11)
#define eIllegalCmd				(-12)
#define eCancel					(-13)

// Leading trichar sequence

#define UPPER_UPPER_lower (1)
#define lower_UPPER_lower (2)
#define lower_UPPER_UPPER (3)
#define lower_lower_UPPER (4)
#define lower_UPPER       (5)
#define lower_case        (6)
#define UPPER_CASE        (7)
#define UPPER_lower		  (8)

#define WORD_DUPLICATED     (1)
#define WORD_NOT_DUPLICATED (0)

// ----------------------------------------------------------------------------------
// Types
// ----------------------------------------------------------------------------------
#ifndef SW_TYPES__
#define SW_TYPES__

//typedef unsigned char UInt8;		// One byte
typedef struct WordInfo {
	short	Case;
	short	Duplicate;
	short	Replace;
} WordInfo;

typedef short (*CallBackProc)();

#endif




#define IS_SPELLED_CORRECTLY     (1)
#define IS_NOT_SPELLED_CORRECTLY (0)

#define MAXlong (unsigned long) (-1)

/* Definitions used when specifying dictionary types */

#define AUTO_DICT          (1)
#define SUGGEST_DICT       (2)
#define DOCUMENT_DICT      (4)
#define SKIP_DICT          (8)
#define USER_DICT          (16)
#define MAIN_DICT          (32)

#ifdef __WINDOWS_DLL__
//#define FuncType		_far _export
//#define FuncType		 _export
//#define  FuncType __declspec( dllimport )
#define FuncType __declspec( dllexport )
#else
#define FuncType
#endif

#ifndef __cplusplus

void 	 FuncType	*StartSpellCheckSession();
void 	 FuncType	EndSpellCheckSession(void *Speller);
short  FuncType 	DictOpen(void *Speller, unsigned long *DictNum, short DictType, long Size, FioParam *theFile);
void   FuncType		DictClose(void *Speller, unsigned long DictNum);
short  FuncType	    SelectWord(void *Speller, char *Word, char *Suggestion);
short  FuncType 	CheckWord(void *Speller, unsigned long DictNum,short DictType, char *Word, WordInfo *Info);
short  FuncType 	FindFirstSuggestion(void *Speller, unsigned long DictNum, short DictType,
			char *Word, char *Suggestion, char *Comment, short *AutoChange, CallBackProc CallBack);
short  FuncType 	FindNextSuggestion(void *Speller, unsigned long DictNum, short DictType,
			char *Word, char *Suggestion, char *Comment, short *AutoReplace, CallBackProc CallBack);
short  FuncType 	AddToDictionary(void *Speller, unsigned long DictNum, char *Word,
			char *Suggestion, char *Comment);
short  FuncType 	FindFirstRegex(void *Speller, unsigned long DictNum, short DictType, char *Word,
			CallBackProc CallBack);
short  FuncType 	FindNextRegex(void *Speller, unsigned long DictNum, short DictType, char *Word,
			CallBackProc CallBack);
short  FuncType 	LocateWord(void *Speller, unsigned long DictNum, short DictType, char *Word);
short  FuncType 	NextWord(void *Speller, unsigned long DictNum, short DictType, char *Word);
short  FuncType 	CurrentWord(void *Speller, unsigned long DictNum, short DictType, char *Word);
short	 FuncType	GetSpellError();
void   FuncType	FixCase(void *Speller, char *Word, short CaseCode);


#endif

#ifdef __cplusplus

extern "C"  void*	FuncType	StartSpellCheckSession();
extern "C"  void  FuncType	EndSpellCheckSession(void *Speller);
extern "C"  short FuncType	DictOpen(void *Speller, unsigned long *DictNum, short DictType,
							long Size, FioParam *theFile);
extern "C"  void  FuncType	DictClose(void *Speller, unsigned long DictNum);
extern "C"  short	FuncType	SelectWord(void *Speller, char *Word, char *Suggestion);
extern "C"  short FuncType 	CheckWord(void *Speller, unsigned long DictNum,short DictType,
							char *Word, WordInfo *Info);
extern "C"  short FuncType 	FindFirstSuggestion(void *Speller, unsigned long DictNum, short DictType,
							char *Word, char *Suggestion, char *Comment, short *AutoReplace,  CallBackProc CallBack);
extern "C"  short FuncType  	FindNextSuggestion(void *Speller, unsigned long DictNum, short DictType,
							char *Word, char *Suggestion, char *Comment, short *AutoReplace, CallBackProc CallBack);
extern "C"  short FuncType  	AddToDictionary(void *Speller, unsigned long DictNum, char *Word,
							char *Suggestion, char *Comment);
extern "C"  short FuncType  	FindFirstRegex(void *Speller, unsigned long DictNum, short DictType, char *Word,
							CallBackProc CallBack);
extern "C"  short FuncType  	FindNextRegex(void *Speller, unsigned long DictNum, short DictType, char *Word,
							CallBackProc CallBack);
extern "C"  short FuncType  	LocateWord(void *Speller, unsigned long DictNum, short DictType, char *Word);
extern "C"  short FuncType  	NextWord(void *Speller, unsigned long DictNum, short DictType, char *Word);
extern "C"  short FuncType  	CurrentWord(void *Speller, unsigned long DictNum, short DictType, char *Word);
extern "C"  short	FuncType	GetSpellError();
extern "C"  void  FuncType	FixCase(void *Speller, char *Word, short CaseCode);



#endif // ifdef __cplusplus
#endif // ifndef _SPELLWRI_
